/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import com.bdlington.Catalyst.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_3965;

public class TreeFarm
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgMovement;
    private final Setting<Integer> placeDelay;
    private final Setting<Integer> breakDelay;
    private final Setting<Boolean> rotate;
    private final Setting<Boolean> useBoneMeal;
    private final Setting<Integer> delay;
    private final Setting<Integer> range;
    private final Setting<Boolean> enableMovement;
    private final Setting<Double> movementSpeed;
    private final Setting<Double> stopDistance;
    private final Setting<Double> smoothness;
    private final Setting<Boolean> easeInOut;
    private final Setting<Double> rotationSpeed;
    private int tickCounter;
    private int actionDelay;
    private List<class_2338> farmPositions;
    private int currentFarmIndex;
    private FarmState currentState;
    private class_2338 currentWorkingPos;
    private class_243 targetPosition;
    private class_243 currentVelocity;
    private boolean isMovingToTarget;
    private double currentYaw;
    private double currentPitch;
    private double targetYaw;
    private double targetPitch;
    private int movementTicks;
    private int ticksSinceRotationChange;
    private boolean shouldBeJumping;
    private class_2338 lastSaplingPos;
    private int rotationStabilizeTicks;
    private class_2338 currentBreakingPos;
    private boolean isBreaking;

    public TreeFarm() {
        super(CatalystAddon.CATEGORY, "TreeFarm", "Automatically farms spruce trees in 2x2 patterns with auto-refill.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgMovement = this.settings.createGroup("Movement");
        this.placeDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("place-delay")).description("Delay between placing blocks (ticks).")).defaultValue((Object)1)).min(0).max(10).sliderMax(10).build());
        this.breakDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("break-delay")).description("Delay between breaking blocks (ticks).")).defaultValue((Object)3)).min(1).max(20).sliderMax(20).build());
        this.rotate = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Rotate to look at blocks when interacting.")).defaultValue((Object)true)).build());
        this.useBoneMeal = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("use-bone-meal")).description("Whether to use bone meal to instantly grow trees.")).defaultValue((Object)true)).build());
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("Delay between actions in ticks.")).defaultValue((Object)3)).min(0).max(20).sliderMax(20).build());
        this.range = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("range")).description("Range to work within.")).defaultValue((Object)4)).min(1).max(6).sliderMax(6).build());
        this.enableMovement = this.sgMovement.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-movement")).description("Enable automatic player movement to farming positions.")).defaultValue((Object)false)).build());
        this.movementSpeed = this.sgMovement.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("movement-speed")).description("Speed multiplier for player movement.")).defaultValue(0.15).min(0.05).max(0.5).sliderMax(0.5).build());
        this.stopDistance = this.sgMovement.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("stop-distance")).description("Distance to stop moving before reaching target.")).defaultValue(1.8).min(0.5).max(3.0).sliderMax(3.0).build());
        this.smoothness = this.sgMovement.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("smoothness")).description("Movement smoothness factor (higher = smoother).")).defaultValue(0.8).min(0.1).max(0.95).sliderMax(0.95).build());
        this.easeInOut = this.sgMovement.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ease-in-out")).description("Use ease-in-out movement for more natural motion.")).defaultValue((Object)true)).build());
        this.rotationSpeed = this.sgMovement.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("rotation-speed")).description("How fast to rotate camera (lower = smoother).")).defaultValue(5.0).min(0.0).max(50.0).sliderMax(50.0).build());
        this.tickCounter = 0;
        this.actionDelay = 0;
        this.farmPositions = new ArrayList<class_2338>();
        this.currentFarmIndex = 0;
        this.currentState = FarmState.FINDING_POSITIONS;
        this.currentWorkingPos = null;
        this.targetPosition = null;
        this.currentVelocity = class_243.field_1353;
        this.isMovingToTarget = false;
        this.currentYaw = 0.0;
        this.currentPitch = 0.0;
        this.targetYaw = 0.0;
        this.targetPitch = 0.0;
        this.movementTicks = 0;
        this.ticksSinceRotationChange = 0;
        this.shouldBeJumping = false;
        this.lastSaplingPos = null;
        this.rotationStabilizeTicks = 0;
        this.currentBreakingPos = null;
        this.isBreaking = false;
    }

    public void onActivate() {
        this.farmPositions.clear();
        this.currentFarmIndex = 0;
        this.currentState = FarmState.FINDING_POSITIONS;
        this.tickCounter = 0;
        this.actionDelay = 0;
        this.targetPosition = null;
        this.currentVelocity = class_243.field_1353;
        this.isMovingToTarget = false;
        this.currentYaw = this.mc.field_1724.method_36454();
        this.currentPitch = this.mc.field_1724.method_36455();
        this.targetYaw = this.currentYaw;
        this.targetPitch = this.currentPitch;
        this.movementTicks = 0;
        this.ticksSinceRotationChange = 0;
        this.shouldBeJumping = false;
        this.lastSaplingPos = null;
        this.rotationStabilizeTicks = 0;
        this.currentBreakingPos = null;
        this.isBreaking = false;
        this.findFarmPositions();
    }

    public void onDeactivate() {
        this.stopBreaking();
        this.resetJump();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        this.autoRefillHotbar(class_1802.field_8324, 5);
        this.autoRefillHotbar(class_1802.field_17536, 4);
        if (this.currentState != FarmState.APPLYING_BONEMEAL && this.shouldBeJumping) {
            this.resetJump();
        }
        if (this.tickCounter++ >= (Integer)this.delay.get()) {
            this.tickCounter = 0;
            if (this.actionDelay > 0) {
                --this.actionDelay;
                return;
            }
            ++this.ticksSinceRotationChange;
            if (this.farmPositions.isEmpty()) {
                this.findFarmPositions();
                return;
            }
            switch (this.currentState.ordinal()) {
                case 0: {
                    this.findFarmPositions();
                    if (this.farmPositions.isEmpty()) break;
                    this.currentState = (Boolean)this.enableMovement.get() != false ? FarmState.MOVING_TO_FARM : FarmState.PLACING_SAPLINGS;
                    break;
                }
                case 1: {
                    if (!this.moveToFarmPosition()) break;
                    this.currentState = FarmState.PLACING_SAPLINGS;
                    break;
                }
                case 2: {
                    if (!this.placeSaplings()) break;
                    this.actionDelay = (Integer)this.placeDelay.get();
                    this.currentState = (Boolean)this.useBoneMeal.get() != false ? FarmState.APPLYING_BONEMEAL : FarmState.WAITING_FOR_GROWTH;
                    break;
                }
                case 3: {
                    if (!this.applyBoneMeal()) break;
                    this.actionDelay = (Integer)this.placeDelay.get();
                    this.currentState = FarmState.WAITING_FOR_GROWTH;
                    break;
                }
                case 4: {
                    if (!this.checkTreeGrown()) break;
                    this.actionDelay = (Integer)this.breakDelay.get();
                    this.currentState = FarmState.HARVESTING;
                    break;
                }
                case 5: {
                    if (!this.harvestTree()) break;
                    this.actionDelay = (Integer)this.breakDelay.get();
                    this.moveToNextFarm();
                    this.currentState = (Boolean)this.enableMovement.get() != false ? FarmState.MOVING_TO_FARM : FarmState.PLACING_SAPLINGS;
                }
            }
        }
    }

    private void autoRefillHotbar(class_1792 targetItem, int minAmount) {
        try {
            FindItemResult invItem;
            FindItemResult hotbarItem;
            int selectedSlot = VersionUtil.getSelectedSlot(this.mc.field_1724);
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(selectedSlot);
            if ((stack == null || stack.method_7960() || stack.method_7909() != targetItem || stack.method_7947() <= minAmount) && !(hotbarItem = InvUtils.findInHotbar((class_1792[])new class_1792[]{targetItem})).found() && (invItem = InvUtils.find((class_1792[])new class_1792[]{targetItem})).found()) {
                InvUtils.move().from(invItem.slot()).to(selectedSlot);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void lookAtBlock(class_2338 pos) {
        class_243 targetPos = class_243.method_24953((class_2382)pos);
        class_243 playerPos = this.mc.field_1724.method_33571();
        class_243 direction = targetPos.method_1020(playerPos).method_1029();
        double yaw = Math.toDegrees(Math.atan2(-direction.field_1352, direction.field_1350));
        double pitch = Math.toDegrees(-Math.asin(direction.field_1351));
        this.mc.field_1724.method_36456((float)yaw);
        this.mc.field_1724.method_36457((float)pitch);
        this.ticksSinceRotationChange = 0;
    }

    private void breakBlock(class_2338 pos) {
        if (this.mc.field_1761 != null) {
            this.mc.field_1761.method_2902(pos, class_2350.field_11036);
            class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1886.method_1429(), (boolean)true);
        }
        this.isBreaking = true;
        this.currentBreakingPos = pos;
    }

    private void stopBreaking() {
        if (this.isBreaking) {
            class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1886.method_1429(), (boolean)false);
            this.isBreaking = false;
            this.currentBreakingPos = null;
        }
    }

    private void resetJump() {
        if (this.shouldBeJumping) {
            class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1903.method_1429(), (boolean)false);
            this.shouldBeJumping = false;
        }
    }

    private boolean moveToFarmPosition() {
        class_243 farmCenter;
        if (this.currentFarmIndex >= this.farmPositions.size()) {
            return true;
        }
        class_2338 farmPos = this.farmPositions.get(this.currentFarmIndex);
        class_243 playerPos = this.mc.field_1724.method_19538();
        double distance = playerPos.method_1022(farmCenter = new class_243((double)farmPos.method_10263() + 0.5, (double)farmPos.method_10264(), (double)farmPos.method_10260() + 0.5));
        if (distance <= (Double)this.stopDistance.get()) {
            this.isMovingToTarget = false;
            this.currentVelocity = class_243.field_1353;
            return true;
        }
        if (this.targetPosition == null || !this.isMovingToTarget) {
            this.targetPosition = farmCenter;
            this.isMovingToTarget = true;
            this.movementTicks = 0;
        }
        ++this.movementTicks;
        this.smoothMoveToTarget(farmCenter);
        this.smoothRotateToTarget(farmPos);
        return false;
    }

    private void smoothMoveToTarget(class_243 target) {
        class_243 playerPos = this.mc.field_1724.method_19538();
        class_243 direction = target.method_1020(playerPos);
        double distance = direction.method_1033();
        if (distance < 0.1) {
            return;
        }
        direction = direction.method_1029();
        double speed = (Double)this.movementSpeed.get();
        if (((Boolean)this.easeInOut.get()).booleanValue()) {
            double progress = Math.min((double)this.movementTicks / 20.0, 1.0);
            double easedProgress = this.easeInOutCubic(progress);
            speed *= easedProgress;
            if (distance < 3.0) {
                double slowdownFactor = distance / 3.0;
                speed *= Math.max(0.2, slowdownFactor);
            }
        }
        class_243 desiredVelocity = direction.method_1021(speed);
        double smoothFactor = (Double)this.smoothness.get();
        this.currentVelocity = this.currentVelocity.method_1021(smoothFactor).method_1019(desiredVelocity.method_1021(1.0 - smoothFactor));
        class_243 newPos = playerPos.method_1019(this.currentVelocity);
        double yDiff = target.field_1351 - playerPos.field_1351;
        if (Math.abs(yDiff) > 0.1) {
            double ySpeed = Math.min(0.05, Math.abs(yDiff) * 0.1);
            newPos = new class_243(newPos.field_1352, playerPos.field_1351 + Math.signum(yDiff) * ySpeed, newPos.field_1350);
        }
        if (newPos.method_1022(playerPos) < 0.5) {
            this.mc.field_1724.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        }
    }

    private void smoothRotateToTarget(class_2338 target) {
        if (!((Boolean)this.rotate.get()).booleanValue()) {
            return;
        }
        class_243 targetVec = class_243.method_24953((class_2382)target.method_10074());
        class_243 playerPos = this.mc.field_1724.method_33571();
        class_243 direction = targetVec.method_1020(playerPos).method_1029();
        double yaw = Math.toDegrees(Math.atan2(-direction.field_1352, direction.field_1350));
        double pitch = Math.toDegrees(-Math.asin(direction.field_1351));
        if (!target.equals((Object)this.lastSaplingPos)) {
            this.lastSaplingPos = target;
            this.rotationStabilizeTicks = 0;
            this.targetYaw = yaw;
            this.targetPitch = pitch;
        }
        double diffYaw = this.normalizeYaw(this.targetYaw - (double)this.mc.field_1724.method_36454());
        double diffPitch = this.targetPitch - (double)this.mc.field_1724.method_36455();
        double lerpFactor = 0.3 * (Double)this.rotationSpeed.get();
        double smoothedYaw = (double)this.mc.field_1724.method_36454() + diffYaw * lerpFactor;
        double smoothedPitch = (double)this.mc.field_1724.method_36455() + diffPitch * lerpFactor;
        this.mc.field_1724.method_36456((float)smoothedYaw);
        this.mc.field_1724.method_36457((float)smoothedPitch);
        ++this.rotationStabilizeTicks;
        this.ticksSinceRotationChange = 0;
    }

    private double easeInOutCubic(double t) {
        return t < 0.5 ? 4.0 * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 3.0) / 2.0;
    }

    private double normalizeYaw(double yaw) {
        while (yaw > 180.0) {
            yaw -= 360.0;
        }
        while (yaw < -180.0) {
            yaw += 360.0;
        }
        return yaw;
    }

    private void findFarmPositions() {
        this.farmPositions.clear();
        class_2338 playerPos = this.mc.field_1724.method_24515();
        float yaw = this.mc.field_1724.method_36454();
        int frontX = 0;
        int frontZ = 0;
        yaw = (yaw % 360.0f + 360.0f) % 360.0f;
        if (yaw >= 315.0f || yaw < 45.0f) {
            frontZ = 2;
        } else if (yaw >= 45.0f && yaw < 135.0f) {
            frontX = -2;
        } else if (yaw >= 135.0f && yaw < 225.0f) {
            frontZ = -2;
        } else {
            frontX = 2;
        }
        class_2338 frontPos = playerPos.method_10069(frontX, 0, frontZ);
        if (this.isValidFarmPosition(frontPos)) {
            this.farmPositions.add(frontPos);
        }
        if (this.farmPositions.isEmpty()) {
            for (int x = -((Integer)this.range.get()).intValue(); x <= (Integer)this.range.get(); ++x) {
                for (int z = -((Integer)this.range.get()).intValue(); z <= (Integer)this.range.get(); ++z) {
                    class_2338 pos = playerPos.method_10069(x, 0, z);
                    if (!this.isValidFarmPosition(pos)) continue;
                    this.farmPositions.add(pos);
                    break;
                }
                if (!this.farmPositions.isEmpty()) break;
            }
        }
    }

    private boolean isValidFarmPosition(class_2338 pos) {
        class_2338[] saplingPositions;
        for (class_2338 saplingPos : saplingPositions = this.get2x2Positions(pos)) {
            class_2338 groundPos = saplingPos.method_10074();
            class_2248 groundBlock = this.mc.field_1687.method_8320(groundPos).method_26204();
            if (!this.isValidGroundBlock(groundBlock)) {
                return false;
            }
            class_2248 currentBlock = this.mc.field_1687.method_8320(saplingPos).method_26204();
            if (!(currentBlock.equals(class_2246.field_10124) || currentBlock.equals(class_2246.field_10217) || this.isSpruceLog(currentBlock))) {
                return false;
            }
            for (int i = 1; i <= 6; ++i) {
                class_2248 aboveBlock = this.mc.field_1687.method_8320(saplingPos.method_10086(i)).method_26204();
                if (aboveBlock.equals(class_2246.field_10124) || this.isSpruceLog(aboveBlock) || this.isSpruceLeaves(aboveBlock)) continue;
                return false;
            }
        }
        return true;
    }

    private class_2338[] get2x2Positions(class_2338 basePos) {
        return new class_2338[]{basePos, basePos.method_10069(1, 0, 0), basePos.method_10069(0, 0, 1), basePos.method_10069(1, 0, 1)};
    }

    private boolean placeSaplings() {
        if (this.currentFarmIndex >= this.farmPositions.size()) {
            return true;
        }
        class_2338 farmPos = this.farmPositions.get(this.currentFarmIndex);
        class_2338[] saplingPositions = this.get2x2Positions(farmPos);
        FindItemResult saplings = InvUtils.find((class_1792[])new class_1792[]{class_1802.field_17536});
        if (!saplings.found()) {
            return false;
        }
        for (class_2338 pos : saplingPositions) {
            class_243 blockPos;
            class_243 playerPos;
            double distance;
            if (!this.mc.field_1687.method_8320(pos).method_26204().equals(class_2246.field_10124)) continue;
            this.currentWorkingPos = pos;
            if (((Boolean)this.enableMovement.get()).booleanValue() && (distance = (playerPos = this.mc.field_1724.method_19538()).method_1022(blockPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5))) > 2.2) {
                this.smoothMoveToTarget(blockPos);
                return false;
            }
            this.lookAtBlock(pos);
            if (this.actionDelay <= 0) {
                InvUtils.swap((int)saplings.slot(), (boolean)false);
                BlockUtils.place((class_2338)pos, (FindItemResult)saplings, (boolean)((Boolean)this.rotate.get()), (int)50);
                this.actionDelay = (Integer)this.placeDelay.get();
            }
            return false;
        }
        return true;
    }

    private boolean applyBoneMeal() {
        if (!((Boolean)this.useBoneMeal.get()).booleanValue()) {
            this.resetJump();
            return true;
        }
        if (this.currentFarmIndex >= this.farmPositions.size()) {
            this.resetJump();
            return true;
        }
        class_2338 farmPos = this.farmPositions.get(this.currentFarmIndex);
        class_2338[] saplingPositions = this.get2x2Positions(farmPos);
        FindItemResult boneMeal = InvUtils.find((class_1792[])new class_1792[]{class_1802.field_8324});
        if (!boneMeal.found()) {
            this.resetJump();
            return true;
        }
        if (!this.shouldBeJumping) {
            class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1903.method_1429(), (boolean)true);
            this.shouldBeJumping = true;
        }
        for (class_2338 pos : saplingPositions) {
            class_243 blockPos;
            class_243 playerPos;
            double distance;
            if (!this.mc.field_1687.method_8320(pos).method_26204().equals(class_2246.field_10217)) continue;
            this.currentWorkingPos = pos;
            if (((Boolean)this.enableMovement.get()).booleanValue() && (distance = (playerPos = this.mc.field_1724.method_19538()).method_1022(blockPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5))) > 2.2) {
                this.smoothMoveToTarget(blockPos);
                return false;
            }
            if (((Boolean)this.rotate.get()).booleanValue()) {
                this.smoothRotateToTarget(pos);
                if (this.rotationStabilizeTicks < 3) {
                    return false;
                }
            }
            if (this.actionDelay <= 0) {
                InvUtils.swap((int)boneMeal.slot(), (boolean)false);
                class_243 hitPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
                class_3965 hitResult = new class_3965(hitPos, class_2350.field_11036, pos, false);
                this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, hitResult);
                this.actionDelay = (Integer)this.placeDelay.get();
            }
            return false;
        }
        this.resetJump();
        return true;
    }

    private boolean checkTreeGrown() {
        class_2338[] saplingPositions;
        if (this.currentFarmIndex >= this.farmPositions.size()) {
            return true;
        }
        class_2338 farmPos = this.farmPositions.get(this.currentFarmIndex);
        for (class_2338 pos : saplingPositions = this.get2x2Positions(farmPos)) {
            class_2248 block = this.mc.field_1687.method_8320(pos).method_26204();
            if (!this.isSpruceLog(block)) continue;
            return true;
        }
        return false;
    }

    private boolean harvestTree() {
        class_2338[] saplingPositions;
        if (this.currentFarmIndex >= this.farmPositions.size()) {
            return true;
        }
        FindItemResult axe = InvUtils.find(itemStack -> itemStack.method_7909() instanceof class_1743);
        if (!axe.found()) {
            return true;
        }
        class_2338 farmPos = this.farmPositions.get(this.currentFarmIndex);
        for (class_2338 pos : saplingPositions = this.get2x2Positions(farmPos)) {
            class_243 blockPos;
            class_243 playerPos;
            double distance;
            class_2338 upPos = pos.method_10084();
            class_2248 block = this.mc.field_1687.method_8320(upPos).method_26204();
            if (!this.isSpruceLog(block)) continue;
            this.currentWorkingPos = upPos;
            if (((Boolean)this.enableMovement.get()).booleanValue() && (distance = (playerPos = this.mc.field_1724.method_19538()).method_1022(blockPos = new class_243((double)upPos.method_10263() + 0.5, (double)upPos.method_10264(), (double)upPos.method_10260() + 0.5))) > 2.0) {
                this.smoothMoveToTarget(blockPos);
                return false;
            }
            if (((Boolean)this.rotate.get()).booleanValue()) {
                this.lookAtBlock(upPos);
            }
            if (this.actionDelay <= 0) {
                InvUtils.swap((int)axe.slot(), (boolean)false);
                this.breakBlock(upPos);
                this.actionDelay = (Integer)this.breakDelay.get();
            }
            if (this.mc.field_1687.method_8320(upPos).method_26215()) {
                this.stopBreaking();
                return false;
            }
            return false;
        }
        this.stopBreaking();
        return true;
    }

    private void moveToNextFarm() {
        ++this.currentFarmIndex;
        this.targetPosition = null;
        this.isMovingToTarget = false;
        this.lastSaplingPos = null;
        this.rotationStabilizeTicks = 0;
        if (this.currentFarmIndex >= this.farmPositions.size()) {
            this.currentFarmIndex = 0;
            this.findFarmPositions();
        }
    }

    private boolean isValidGroundBlock(class_2248 block) {
        return block.equals(class_2246.field_10219) || block.equals(class_2246.field_10566) || block.equals(class_2246.field_10253) || block.equals(class_2246.field_10520) || block.equals(class_2246.field_10402);
    }

    private boolean isSpruceLog(class_2248 block) {
        return block.equals(class_2246.field_10037);
    }

    private boolean isSpruceLeaves(class_2248 block) {
        return block.equals(class_2246.field_9988);
    }

    private static enum FarmState {
        FINDING_POSITIONS,
        MOVING_TO_FARM,
        PLACING_SAPLINGS,
        APPLYING_BONEMEAL,
        WAITING_FOR_GROWTH,
        HARVESTING;

    }
}

